<?php
use PragmaRX\Google2FA\Google2FA;

if(!defined('BASEPATH')) {
   die('Direct access to the script is not allowed');
}

if($_POST){
    $username       = $_POST["username"];
    $pass           = $_POST["password"];
    $captcha        = $_POST['g-recaptcha-response'] ?? '';
    $remember       = $_POST["remember"] ?? null;
    $two_factor_code = htmlspecialchars($_POST["two_factor_code"] ?? '');
    
    $googlesecret = $settings["recaptcha_secret"];
    $captcha_control = json_decode(file_get_contents(
        "https://www.google.com/recaptcha/api/siteverify?secret=$googlesecret&response=$captcha&remoteip=".$_SERVER['REMOTE_ADDR']
    ));

    // reCAPTCHA verification
    if($settings["recaptcha"] == 2 && (!$captcha_control->success ?? false) && $_SESSION["recaptcha"]){
        $error = 1;
        $errorText = "Please verify that you are not a robot.";
        $_SESSION["recaptcha"] = true;
    }
    // Suspended account check
    elseif(countRow(["table"=>"admins","where"=>["username"=>$username,"client_type"=>1]])){
        $error = 1;
        $errorText = "Your account is Suspended.";
        $_SESSION["recaptcha"] = true;
    } 
    else {
        $stmt = $conn->prepare("SELECT * FROM admins WHERE username=:username AND password=:password");
        $stmt->execute(["username"=>$username,"password"=>$pass]);
        $admin = $stmt->fetch(PDO::FETCH_ASSOC);

        if($admin){
            $access = json_decode($admin["access"], true);

            $_SESSION["msmbilisim_adminslogin"] = 1;
            $_SESSION["msmbilisim_adminid"] = $admin["admin_id"];
            $_SESSION["msmbilisim_adminpass"] = $pass;
            $_SESSION["recaptcha"] = false;

            if($access["admin_access"]){
                // Two-factor authentication
                if($admin["two_factor"] == 1){
                    $google2fa = new Google2FA();
                    $is_valid = $google2fa->verifyKey($admin["two_factor_secret_key"], $two_factor_code);
                    if(!$is_valid){
                        $error = 1;
                        $errorText = "Invalid Code.";
                    }
                }

                // Set cookies if login successful
                if(!$error){
                    setcookie("a_login", 'ok', time() + 604800, '/', null, null, true);
                    setcookie("a_id", $admin["admin_id"], time() + 604800, '/', null, null, true);
                    setcookie("a_password", $admin["password"], time() + 604800, '/', null, null, true);

                    // Update login info
                    $update = $conn->prepare("UPDATE admins SET login_date=:date, login_ip=:ip WHERE admin_id=:c_id");
                    $update->execute([
                        "c_id"=>$admin["admin_id"],
                        "date"=>date("Y-m-d H:i:s"),
                        "ip"=>GetIP()
                    ]);

                    if($admin["two_factor"] == 1){
                        header('Location: '.site_url('admin'));
                    } else {
                        header('Location: '.site_url('admin/activate-google-2fa'));
                    }
                    exit();
                }
            }
        } else {
            $error = 1;
            $errorText = "Could not find administrator account registered with this information.";
        }
    }
}

if($access["admin_access"] && $_SESSION["msmbilisim_adminslogin"]){
    exit();
} else {
    require admin_view('login');
}
