<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="X-UA-Compatible" content="ie=edge">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css" rel="stylesheet">

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

<style>
html, body { height: 100%; width: 100%; margin: 0; padding: 0; background-color: #f8f9fa; }
* { box-sizing: border-box; }
.method-logo h5, .method-logo h6 { margin-bottom: 15px; }
.method-logo img { max-width: 100%; height: auto; }
form { width: 100%; padding: 20px; background: #fff; border-radius: 12px; box-shadow: 0 0 15px rgba(0,0,0,0.05); }
@media(min-width: 768px){ form { max-width: 450px; } }
.btn i { cursor: pointer; }
</style>
</head>
<body>
<div class="d-flex align-items-center justify-content-center vh-100">
    <form action="<?= site_url("admin/activate-google-2fa") ?>" method="POST">
        <div class="text-center method-logo">
            <h5>Add an extra layer of security to the admin page.</h5>
            <h6>Scan the QR Code or Enter the Code in <a target="_blank" href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2">Google Authenticator</a> App.</h6>
            <img src="data:image/png;base64,<?=$encoded_qr_data?>" alt="Google Authenticator Setup QR Code" class="rounded mb-3">
            <p class="h6">Code: <strong class="text-success"><?=$GoogleTFA_admin->google2fa_secret?></strong> 
                <span onclick="copyToClipboard('<?=$GoogleTFA_admin->google2fa_secret?>')"><i class="fas fa-copy"></i></span>
            </p>
        </div>

        <div class="error mb-3"></div>

        <input type="hidden" id="secret_key" name="secret_key" value="<?=$GoogleTFA_admin->google2fa_secret?>">

        <div class="mb-3">
            <label for="2FA_Code" class="form-label">6-Digit Code from Google Authenticator App</label>
            <input type="number" class="form-control" id="2FA_Code" name="2FA_Code" placeholder="Enter Code" autocomplete="off" required>
        </div>

        <div class="d-grid gap-2">
            <button type="submit" class="btn btn-primary">Enable Two-Step Verification</button>
            <a href="<?= site_url("admin") ?>" class="btn btn-warning">Skip for now</a>
        </div>
    </form>
</div>

<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(() => alert("Copied to clipboard!"), (err) => alert("Failed to copy: "+err));
}

$(document).ready(function() {
    $("form").submit(function(e) {
        e.preventDefault();
        var secret_key = $("#secret_key").val();
        var _2fa_code = $("#2FA_Code").val();
        var error = $(".error");

        $.ajax({
            url: "<?= site_url("admin/activate-google-2fa") ?>",
            type: "POST",
            data: { secret_key: secret_key, "2FA_Code": _2fa_code },
            success: function(response) {
                var res = JSON.parse(response);
                if(res.success) {
                    error.html('<div class="alert alert-success alert-dismissible fade show" role="alert"><strong>' + res.message + '</strong><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>');
                    setTimeout(function(){ window.location.href = "<?= site_url("admin") ?>"; }, 1500);
                } else {
                    error.html('<div class="alert alert-danger alert-dismissible fade show" role="alert"><strong>' + res.message + '</strong><button type="button" class="btn-close" data-bs-dismiss="alert"></button></div>');
                }
            }
        });
    });
});
</script>
</body>
</html>
