<?php if( !route(3) ): ?>
<div class="col-md-8 col-sm-12">
  <div class="panel panel-default">
    <div class="panel-heading">
      <h4>Themes</h4>
    </div>
    <div class="panel-body table-responsive">
      <table class="table table-striped table-hover">
        <thead>
          <tr>
            <th>Theme</th>
            <th>Last Modified</th>
            <th class="text-right">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($themes as $theme): ?>
          <tr>
            <td>
              <?= $theme["theme_name"] ?>
              <?php if($settings["site_theme"] == $theme["theme_dirname"]): ?>
                <span class="badge badge-success">Active</span>
              <?php endif; ?>
            </td>
            <td>
           
<?php
  $datetime = new DateTime($theme["last_modified"]);
  echo $datetime->format('l, d F Y, h:i:s A'); 
?>


              <?php if($settings["site_theme"] == $theme["theme_dirname"] && $theme["colour"] == "2"): ?>
                <div class="dropdown pull-right">
                  <button class="btn btn-default btn-xs dropdown-toggle" type="button" data-toggle="dropdown">
                    Colour Change <span class="caret"></span>
                  </button>
                  <ul class="dropdown-menu p-3">
                    <form action="" method="post">
                      <div class="form-group">
                        <select class="form-control" name="site_theme_alt">
                          <?php
                          $colours = [];
                          switch($theme["theme_dirname"]){
                            case "Simplify":
                            case "ShineVibes":
                              $colours = ["Red","Blue","Lime","Grapes","Dark","Cyan","Coral","Green","Grey","Lilac","Orange"];
                              break;
                            case "Eternity":
                              $colours = ["lilac","coral","azure","grey","lime","navy","pink","raspberry","cyan","purple"];
                              break;
                            case "pitchy":
                              $colours = ["green","parrot","orange"];
                              break;
                            case "Creon":
                              $colours = ["Yellow"];
                              break;
                          }
                          foreach($colours as $c) echo "<option value='{$c}'>{$c}</option>";
                          ?>
                        </select>
                      </div>
                      <div class="text-center">
                        <button type="submit" class="btn btn-default btn-sm">Update</button>
                      </div>
                    </form>
                  </ul>
                </div>
              <?php endif; ?>
            </td>
            <td class="text-right">
              <div class="dropdown">
                <button type="button" class="btn btn-default btn-xs dropdown-toggle" data-toggle="dropdown">
                  Options <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                  <?php if($settings["site_theme"] != $theme["theme_dirname"]): ?>
                    <li><a href="<?= site_url('admin/appearance/themes/active/'.$theme["id"]) ?>">Activate</a></li>
                  <?php endif; ?>
                  <li><a href="<?= site_url('admin/appearance/themes/'.$theme["id"]) ?>">Edit</a></li>
                </ul>
              </div>
            </td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>


<?php elseif(route(3)): ?>
<div class="col-md-12 col-sm-12">
  <div class="panel panel-default">
    <div class="panel-heading"><strong><?= $theme["theme_name"] ?></strong> - Edit Theme</div>
    <div class="row">
      <!-- Sidebar -->
      <div class="col-md-3 col-sm-12">
        <div class="panel-body">
          <div class="twig-editor-block">
            <?php
            $layouts = [
              "HTML"=>["header.twig","footer.twig","account.twig","addfunds.twig","api.twig","child-panels.twig","login.twig","neworder.twig","open_ticket.twig","orders.twig","refill.twig","signup.twig","services.twig","tickets.twig","refer.twig","dripfeeds.twig","subscriptions.twig","resetpassword.twig","setnewpassword.twig","updates.twig","blog.twig","blogpost.twig","terms.twig","faq.twig"],
              "CSS"=>["bootstrap.css","style.css"],
              "JS"=>["bootstrap.js","script.js"]
            ];
            foreach($layouts as $type => $files):
              echo '<div class="twig-editor-list-title" data-toggle="collapse" href="#folder_'.$type.'"><span class="fa fa-folder-open"></span> '.$type.'</div>';
              echo '<ul class="twig-editor-list collapse in" id="folder_'.$type.'">';
              foreach($files as $file):
                $active = ($lyt == $file) ? ' class="active file-modified"' : '';
                echo '<li'.$active.'><a href="'.site_url('admin/appearance/themes/'.$theme["id"]).'?file='.$file.'">'.$file.'</a></li>';
              endforeach;
              echo '</ul>';
            endforeach;
            ?>
          </div>
        </div>
      </div>

      <!-- Editor -->
      <div class="col-md-9 col-sm-12">
        <?php if(!$lyt): ?>
          <div class="panel-body">
            <div class="alert alert-info">Select a file from the left sidebar to start editing.</div>
          </div>
        <?php else: ?>
          <div id="fullscreen">
            <div class="panel-body">
              <?php
              $text = htmlspecialchars(file_get_contents($fn));
              ?>
              <div class="row">
                <div class="col-md-8"><strong><?= $dir.'/'.$lyt ?></strong></div>
                <div class="col-md-4 text-right">
                  <a class="btn btn-xs btn-default fullScreenButton"><span class="glyphicon glyphicon-fullscreen"></span> Edit Full Screen</a>
                </div>
              </div>
              <form action="<?= site_url("admin/appearance/themes/".$theme["id"]."?file=".$lyt) ?>" method="post">
                <textarea id="code" name="code" class="codemirror-textarea"><?= $text; ?></textarea>
                <div class="text-right mt-2">
                  <button class="btn btn-primary">Save</button>
                </div>
              </form>
            </div>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<?php endif; ?>

<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/codemirror/3.20.0/codemirror.css">
<script src="//cdnjs.cloudflare.com/ajax/libs/codemirror/3.20.0/codemirror.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/codemirror/3.20.0/mode/xml/xml.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/codemirror/2.36.0/formatting.js"></script>

<style>
  .badge-success { background-color: #28a745; }
  .table-responsive { overflow-x:auto; }
  .twig-editor-list-title { cursor:pointer; margin:5px 0; font-weight:bold; }
  .twig-editor-list li a { display:block; padding:5px; text-decoration:none; }
  .file-modified a { font-weight:bold; color:#007bff; }
  @media(max-width:768px){
    .col-md-8, .col-md-9, .col-md-3 { margin-bottom:15px; }
  }
</style>
