<?php include 'header.php'; ?>
<style>
.container-fluid { width:100% }
.clients-table { overflow-x:auto; border:1px solid #dbdbdb }
.btn i { margin-right:6px; }
</style>

<div class="container-fluid p-3">
  <ul class="nav nav-tabs flex-wrap">
    <li class="p-b m-r">
      <button class="btn btn-default" type="button" data-toggle="modal" data-target="#modalDiv" data-action="new_user">
        <i class="fa-solid fa-user-plus"></i> Add User
      </button>
    </li>
    <li class="p-b m-r">
      <button class="btn btn-default" type="button" data-toggle="modal" data-target="#modalDiv" data-action="export_user">
        <i class="fa-solid fa-download"></i> Backup Users
      </button>
    </li>
    <li class="p-b m-r">
      <button class="btn btn-default" type="button" data-toggle="modal" data-target="#modalDiv" data-action="alert_user">
        <i class="fa-solid fa-bell"></i> Send Notification
      </button>
    </li>
    <li class="p-b m-r">
      <button class="btn btn-default" type="button" data-toggle="modal" data-target="#modalDiv" data-action="all_numbers">
        <i class="fa-solid fa-address-book"></i> Contact Info
      </button>
    </li>
    <li class="p-b m-r">
      <button class="btn btn-default" type="button" data-toggle="modal" data-target="#modalDiv" data-action="details">
        <i class="fa-solid fa-circle-info"></i> Details
      </button>
    </li>
    <li class="p-b m-r">
      <button class="custom_method btn btn-default" data-title="Remove all Fake Users?" data-message="Are you sure? This action can't be reversed?" data-url="admin/clients/delete_fake_users">
        <i class="fa-solid fa-user-slash"></i> Remove Fake Users
      </button>
    </li>
  </ul>

  <!-- Search bar -->
  <form class="form-inline mt-3" action="" method="get" enctype="multipart/form-data">
    <div class="input-group">
      <input type="text" name="search" class="form-control" value="<?=$search_word?>" placeholder="Search user...">
      <span class="input-group-btn search-select-wrap">
        <select class="form-control search-select" name="search_type">
          <option value="username" <?php if( $search_where == "username" ): echo 'selected'; endif; ?> >Username</option>
          <option value="name" <?php if( $search_where == "name" ): echo 'selected'; endif; ?> >Name</option>
          <option value="email" <?php if( $search_where == "email" ): echo 'selected'; endif; ?> >Email</option>
          <option value="telephone" <?php if( $search_where == "telephone" ): echo 'selected'; endif; ?> >Phone</option>
        </select>
        <button type="submit" class="btn btn-default">
          <i class="fa-solid fa-magnifying-glass"></i>
        </button>
      </span>
    </div>
  </form>

  <!-- Clients Table -->
  <div class="clients-table mt-3">
    <table class="table table-bordered table-hover">
      <thead class="table-light">
        <tr>
          <th>ID</th>
          <th width="10%">Username</th>
          <th>Email</th>
          <th>Balance</th>
          <th>Spent</th>
          <th>Orders</th>
          <th>Services Discount</th>
          <th>Special Pricing</th>
          <th>Registered Date</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
      <?php foreach($clients as $client ): ?>
        <tr class="<?php if( $client["client_type"] == 1 ): echo "table-secondary"; endif; ?>">
          <td><?php echo $client["client_id"] ?></td>
          <td>
            <?php echo $client["username"] ?>
            <a href="<?= site_url('admin/clients/view/' . $client['client_id']) ?>">
              <i class="fa-solid fa-arrow-up-right-from-square text-primary"></i>
            </a>
          </td>
          <td>
            <?php echo $client["email"] ?>
            <?php if ($client["email_type"] == 2): ?>
              <i class="fa-solid fa-circle-check text-success" title="Email Verified"></i>
            <?php else: ?>
              <i class="fa-solid fa-circle-xmark text-danger" title="Email Not Verified"></i>
            <?php endif; ?>
          </td>
          <td><?= format_amount_string($settings["site_base_currency"],$client["balance"]); ?></td>
          <td><?= format_amount_string($settings["site_base_currency"],$client["spent"]); ?></td>
          <td><?= countRow(["table"=>"orders","where"=>["client_id"=>$client["client_id"]] ]) ?></td>
          <td>
            <button type="button" class="btn btn-info btn-xs disabled" data-toggle="modal" data-target="#modalDiv" data-id="<?php echo $client["client_id"] ?>" data-action="set_discount_percentage">
              <i class="fa-solid fa-percent"></i> (<?php echo $client ["discount_percentage"]; ?>%)
            </button>
          </td>
          <td>
            <a class="btn btn-warning btn-xs" href="<?php echo site_url("admin/special-pricing/".$client["client_id"]."");?>">
              <i class="fa-solid fa-tags"></i> Special Pricing
              <span class="badge bg-dark"><?php echo countRow(["table"=>"clients_price","where"=>["client_id"=>$client["client_id"]] ]) ?></span>
            </a>
          </td>
          <td><?php echo date('jS M Y \a\t g:ia',strtotime($client["register_date"])); ?></td>
          <td>
            <div class="dropdown">
              <button class="btn btn-primary btn-xs dropdown-toggle" data-toggle="dropdown">Action</button>
              <ul class="dropdown-menu dropdown-menu-right">
                <li><a href="<?php echo site_url("admin/clients/view/".$client["client_id"]) ?>"><i class="fa-solid fa-eye"></i> View User</a></li>
                <li><a data-toggle="modal" data-target="#modalDiv" data-action="edit_user" data-id="<?=$client["client_id"]?>"><i class="fa-solid fa-pen"></i> Edit User</a></li>
                <li><a data-toggle="modal" data-target="#modalDiv" data-action="pass_user" data-id="<?=$client["client_id"]?>"><i class="fa-solid fa-key"></i> Change Password</a></li>
                <li><a data-toggle="modal" data-target="#modalDiv" data-action="secret_user" data-id="<?=$client["client_id"]?>"><i class="fa-solid fa-layer-group"></i> Edit Categories</a></li>
                <li><a href="<?php echo site_url("admin/clients/change_apikey/".$client["client_id"]) ?>"><i class="fa-solid fa-arrows-rotate"></i> Set New API Key</a></li>
                <li>
                  <a href="<?php echo site_url("admin/clients/".($client["client_type"] == 1 ? "active":"deactive")."/".$client["client_id"]) ?>">
                    <i class="fa-solid fa-user-gear"></i>
                    <?php echo $client["client_type"] == 1 ? "Activate" : "Deactivate"; ?> Account
                  </a>
                </li>
                <li><a href="<?php echo site_url("admin/clients/del_price/".$client["client_id"]) ?>"><i class="fa-solid fa-rotate-left"></i> Reset Pricing</a></li>
              </ul>
            </div>
          </td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>

  <!-- Pagination -->
  <?php if( $paginationArr["count"] > 1 ): ?>
    <nav aria-label="Page navigation">
      <ul class="pagination">
        <?php if( $paginationArr["current"] != 1 ): ?>
          <li class="page-item"><a class="page-link" href="<?php echo site_url("admin/clients/1".$search_link) ?>">&laquo;</a></li>
          <li class="page-item"><a class="page-link" href="<?php echo site_url("admin/clients/".$paginationArr["previous"].$search_link) ?>">&lsaquo;</a></li>
        <?php endif; ?>
        <?php for ($page=1; $page<=$pageCount; $page++): ?>
          <?php if( $page >= ($paginationArr['current']-5) and $page <= ($paginationArr['current']+5) ): ?>
            <li class="page-item <?php if( $page == $paginationArr["current"] ): echo "active"; endif; ?>">
              <a class="page-link" href="<?php echo site_url("admin/clients/".$page.$search_link) ?>"><?=$page?></a>
            </li>
          <?php endif; endfor; ?>
        <?php if( $paginationArr["current"] != $paginationArr["count"] ): ?>
          <li class="page-item"><a class="page-link" href="<?php echo site_url("admin/clients/".$paginationArr["next"].$search_link) ?>">&rsaquo;</a></li>
          <li class="page-item"><a class="page-link" href="<?php echo site_url("admin/clients/".$paginationArr["count"].$search_link) ?>">&raquo;</a></li>
        <?php endif; ?>
      </ul>
    </nav>
  <?php endif; ?>
</div>

<!-- Confirm Modal -->
<div class="modal fade" id="confirmChange" tabindex="-1" role="dialog" aria-labelledby="confirmChangeLabel" data-backdrop="static">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-body text-center">
        <h4>Are you sure you want to update the status?</h4>
        <div class="mt-3">
          <a class="btn btn-primary" href="" id="confirmYes">Yes</a>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">No</button>
        </div>
      </div>
    </div>
  </div>
</div>

<?php include 'footer.php'; ?>
