<!DOCTYPE html>
<html lang="en" class="scroll-smooth">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - <?= $settings['site_name'] ?? 'Dashboard' ?> | Secure Access Portal</title>
    <meta name="description" content="Secure admin login panel for <?= $settings['site_name'] ?? 'your site' ?> management system. Access your dashboard with enhanced security.">
    <meta name="keywords" content="admin login, dashboard, secure access, <?= $settings['site_name'] ?? 'site' ?> admin">
    <meta name="robots" content="noindex, nofollow">

    <!-- Tailwind CSS CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- FontAwesome for icons -->
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>

    <style>
        /* Dark/Light mode toggle */
        html {
            transition: background-color 0.3s, color 0.3s;
        }
        .input-icon {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: #9ca3af;
        }
        .form-input {
            padding-left: 2.5rem;
            transition: all 0.3s;
        }
        .form-input:focus {
            outline: none;
            border-color: #6366f1;
            box-shadow: 0 0 0 1px #6366f1;
        }
        .password-toggle {
            position: absolute;
            right: 1rem;
            top: 50%;
            transform: translateY(-50%);
            background: transparent;
            border: none;
            cursor: pointer;
            color: #6b7280;
        }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center bg-gray-100 dark:bg-gray-900 transition-colors">

    <div class="w-full max-w-md p-8 space-y-6 bg-white dark:bg-gray-800 rounded-xl shadow-lg transition-colors">
        <h2 class="text-2xl font-bold text-gray-800 dark:text-gray-100 text-center">Admin Login</h2>

        <?php if($success): ?>
            <div class="flex items-center bg-green-100 text-green-800 p-3 rounded">
                <i class="fas fa-check-circle mr-2"></i>
                <span><?= $successText ?></span>
            </div>
        <?php endif; ?>
        
        <?php if($error): ?>
            <div class="flex items-center bg-red-100 text-red-800 p-3 rounded">
                <i class="fas fa-exclamation-triangle mr-2"></i>
                <span><?= $errorText ?></span>
            </div>
        <?php endif; ?>

        <form method="post" action="#" id="loginForm" class="space-y-4 relative">
            <!-- Username -->
            <div class="relative">
                <input type="text" id="username" name="username" placeholder="Enter your username" required autocomplete="username"
                       class="form-input w-full border border-gray-300 dark:border-gray-600 rounded px-3 py-2 text-gray-800 dark:text-gray-100 bg-gray-50 dark:bg-gray-700 focus:ring-1 focus:ring-indigo-500">
                <i class="fas fa-user input-icon"></i>
            </div>

            <!-- Password -->
            <div class="relative">
                <input type="password" id="password" name="password" placeholder="Enter your password" required autocomplete="current-password"
                       class="form-input w-full border border-gray-300 dark:border-gray-600 rounded px-3 py-2 text-gray-800 dark:text-gray-100 bg-gray-50 dark:bg-gray-700 focus:ring-1 focus:ring-indigo-500">
                <i class="fas fa-lock input-icon"></i>
                <button type="button" class="password-toggle" id="togglePassword">
                    <i class="far fa-eye"></i>
                </button>
            </div>

            <?php if(isset($settings["two_factor"]) && $settings["two_factor"] == 1): ?>
            <!-- Two Factor Code -->
            <div class="relative">
                <input type="number" id="two_factor_code" name="two_factor_code" placeholder="Enter 6-digit code" inputmode="numeric"
                       class="form-input w-full border border-gray-300 dark:border-gray-600 rounded px-3 py-2 text-gray-800 dark:text-gray-100 bg-gray-50 dark:bg-gray-700 focus:ring-1 focus:ring-indigo-500">
                <i class="fas fa-mobile-alt input-icon"></i>
            </div>
            <?php endif; ?>

            <!-- Remember Me -->
            <div class="flex items-center justify-between">
                <label class="flex items-center space-x-2">
                    <input type="checkbox" class="form-check-input w-4 h-4 text-indigo-600 border-gray-300 rounded focus:ring-indigo-500">
                    <span class="text-gray-700 dark:text-gray-200 text-sm">Remember me</span>
                </label>
            </div>

            <button type="submit" id="loginButton" 
                    class="w-full bg-indigo-600 hover:bg-indigo-700 text-white font-semibold py-2 px-4 rounded shadow transition-colors flex items-center justify-center space-x-2">
                <i class="fas fa-sign-in-alt"></i><span>Sign In</span>
            </button>
        </form>


    </div>

    <script>
        // Password toggle
        const password = document.getElementById('password');
        const toggle = document.getElementById('togglePassword');
        toggle.addEventListener('click', () => {
            const type = password.type === 'password' ? 'text' : 'password';
            password.type = type;
            toggle.innerHTML = type === 'password' ? '<i class="far fa-eye"></i>' : '<i class="far fa-eye-slash"></i>';
        });

    </script>
</body>
</html>
