<div class="col-md-8 col-sm-12">
  <div class="panel panel-default">
    <div class="panel-heading text-center">
      <h4>General Settings</h4>
    </div>
    <div class="panel-body">
      <form action="" method="post" enctype="multipart/form-data">

        <!-- Site Logo -->
        <div class="form-group">
          <div class="row">
            <div class="col-md-10 col-sm-9">
              <label for="preferenceLogo" class="control-label">Site Logo</label>
              <input type="file" name="logo" id="preferenceLogo">
            </div>
            <div class="col-md-2 col-sm-3 text-center">
              <?php if($settings["site_logo"]): ?>
              <div class="setting-block__image">
                <img class="img-thumbnail img-responsive" src="<?=$settings["site_logo"]?>">
                <div class="setting-block__image-remove">
                  <a href="" data-toggle="modal" data-target="#confirmChange" data-href="<?=site_url("admin/settings/general/delete-logo")?>">
                    <span class="fa fa-remove"></span>
                  </a>
                </div>
              </div>
              <?php endif; ?>
            </div>
          </div>
        </div>

        <!-- Site Favicon -->
        <div class="form-group">
          <div class="row">
            <div class="col-md-11 col-sm-9">
              <label for="preferenceFavicon" class="control-label">Site Favicon</label>
              <input type="file" name="favicon" id="preferenceFavicon">
            </div>
            <div class="col-md-1 col-sm-3 text-center">
              <?php if($settings["favicon"]): ?>
              <div class="setting-block__image">
                <img class="img-thumbnail img-responsive" src="<?=$settings["favicon"]?>">
                <div class="setting-block__image-remove">
                  <a href="" data-toggle="modal" data-target="#confirmChange" data-href="<?=site_url("admin/settings/general/delete-favicon")?>">
                    <span class="fa fa-remove"></span>
                  </a>
                </div>
              </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
        <hr>

        <!-- Maintenance Mode -->
        <div class="form-group">
          <label class="control-label">Maintenance Mode</label>
          <select class="form-control" name="site_maintenance">
            <option value="2" <?= $settings["site_maintenance"] == 2 ? "selected" : null; ?>>Inactive</option>
            <option value="1" <?= $settings["site_maintenance"] == 1 ? "selected" : null; ?>>Active</option>
          </select>
        </div>
        <hr>

        <!-- Panel Name -->
        <div class="form-group">
          <label class="control-label">Panel Name</label>
          <input type="text" class="form-control" name="name" value="<?=$settings["site_name"]?>">
        </div>
        <hr>

        <!-- Reset Password Options -->
        <div class="alert alert-info">
          <div class="row">
            <div class="form-group col-md-4 col-sm-12">
              <label class="control-label">Reset Password</label>
              <select class="form-control" name="resetpass">
                <option value="2" <?= $settings["resetpass_page"] == 2 ? "selected" : ""; ?>>Enabled</option>
                <option value="1" <?= $settings["resetpass_page"] == 1 ? "selected" : ""; ?>>Disabled</option>
              </select>
            </div>
            <div class="form-group col-md-4 col-sm-12">
              <label class="control-label">Reset Using SMS</label>
              <select class="form-control" name="resetsms">
                <option value="2" <?= $settings["resetpass_sms"] == 2 ? "selected" : ""; ?>>Enabled</option>
                <option value="1" <?= $settings["resetpass_sms"] == 1 ? "selected" : ""; ?>>Disabled</option>
              </select>
            </div>
            <div class="form-group col-md-4 col-sm-12">
              <label class="control-label">Reset Using Email</label>
              <select class="form-control" name="resetmail">
                <option value="2" <?= $settings["resetpass_email"] == 2 ? "selected" : ""; ?>>Enabled</option>
                <option value="1" <?= $settings["resetpass_email"] == 1 ? "selected" : ""; ?>>Disabled</option>
              </select>
            </div>
          </div>
        </div>
        <hr>

        <!-- Ticket System -->
        <div class="alert alert-warning">
          <div class="form-group">
            <label class="control-label">Ticket System</label>
            <select class="form-control" name="ticket_system">
              <option value="1" <?= $settings["ticket_system"] == 1 ? "selected" : ""; ?>>Enabled</option>
              <option value="2" <?= $settings["ticket_system"] == 2 ? "selected" : ""; ?>>Disabled</option>
            </select>
          </div>
          <div class="form-group">
            <label class="control-label">Max Pending Tickets per User</label>
            <select class="form-control" name="tickets_per_user">
              <?php for($i=1;$i<=10;$i++): ?>
              <option value="<?=$i?>" <?= $settings["tickets_per_user"]==$i ? "selected" : ""; ?>><?=$i?></option>
              <?php endfor; ?>
              <option value="9999999999" <?= $settings["tickets_per_user"]==9999999999 ? "selected" : ""; ?>>Unlimited</option>
            </select>
          </div>
        </div>
        <hr>

        <!-- Signup Page -->
        <div class="alert alert-success">
          <div class="form-group">
            <label class="control-label">Signup Page <i class="fa fa-info-circle" title="Allows Users to register"></i></label>
            <select class="form-control" name="registration_page">
              <option value="2" <?= $settings["register_page"] == 2 ? "selected" : ""; ?>>Enabled</option>
              <option value="1" <?= $settings["register_page"] == 1 ? "selected" : ""; ?>>Disabled</option>
            </select>
          </div>

          <div class="form-group">
            <label class="control-label">Name Fields <i class="fa fa-info-circle" title="Name field on the Signup page"></i></label>
            <select class="form-control" name="name_fileds">
              <option value="1" <?= $settings["name_fileds"] == 1 ? "selected" : ""; ?>>Enabled</option>
              <option value="2" <?= $settings["name_fileds"] == 2 ? "selected" : ""; ?>>Disabled</option>
            </select>
          </div>

          <div class="form-group">
            <label class="control-label">Skype Fields <i class="fa fa-info-circle" title="Skype field on the Signup page"></i></label>
            <select class="form-control" name="skype_feilds">
              <option value="1" <?= $settings["skype_feilds"] == 1 ? "selected" : ""; ?>>Enabled</option>
              <option value="2" <?= $settings["skype_feilds"] == 2 ? "selected" : ""; ?>>Disabled</option>
            </select>
          </div>

          <div class="form-group">
            <label class="control-label">Email Confirmation <i class="fa fa-info-circle" title="Enables mandatory email confirmation for the user"></i></label>
            <select class="form-control" name="email_confirmation">
              <option value="1" <?= $settings["email_confirmation"] == 1 ? "selected" : ""; ?>>Enabled</option>
              <option value="2" <?= $settings["email_confirmation"] == 2 ? "selected" : ""; ?>>Disabled</option>
            </select>
          </div>

          <div class="form-group">
            <label class="control-label">Transfer Funds Percentage <span class="fa fa-percent"></span></label>
            <input type="number" class="form-control" name="fundstransfer_fees" value="<?= $settings["fundstransfer_fees"]; ?>">
          </div>

          <div class="form-group">
            <label class="control-label">Resend Link Max <small>(Recommended 2)</small></label>
            <input type="text" class="form-control" name="resend_max" value="<?=$settings["resend_max"]?>">
          </div>
        </div>
        <hr>

        <!-- Header & Footer Custom Codes -->
        <div class="alert alert-info">
          <div class="form-group">
            <label class="control-label">Header Codes</label>
            <textarea class="form-control" rows="5" name="custom_header" placeholder='<style type="text/css">...</style>'><?=$settings["custom_header"]?></textarea>
          </div>
          <div class="form-group">
            <label class="control-label">Footer Codes</label>
            <textarea class="form-control" rows="5" name="custom_footer" placeholder='<script>...</script>'><?=$settings["custom_footer"]?></textarea>
          </div>
        </div>
        <hr>

        <button type="submit" class="btn btn-primary btn-block">Update Settings</button>
      </form>
    </div>
  </div>
</div>

<!-- Modal for Confirmation -->
<div class="modal fade" id="confirmChange" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" data-backdrop="static">
  <div class="modal-dialog modal-dialog-center" role="document">
    <div class="modal-content">
      <div class="modal-body text-center">
        <h4>Are you sure?</h4>
        <div class="mt-3">
          <a class="btn btn-primary" href="" id="confirmYes">Yes</a>
          <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
        </div>
      </div>
    </div>
  </div>
</div>

<style>
  .panel-heading {
    background-color: #007bff;
    color: #fff;
    font-weight: bold;
  }
  .img-thumbnail {
    max-width: 100%;
    height: auto;
  }
  .alert {
    padding: 15px;
    margin-bottom: 20px;
    border-radius: 4px;
  }
  @media(max-width:768px){
    .col-md-4, .col-md-10, .col-md-11, .col-md-2 {
      margin-bottom: 10px;
    }
  }
</style>
