<?php
if(!defined('BASEPATH')) {
   die('Direct access to the script is not allowed');
}

require 'google-api/vendor/autoload.php';

if ($settings["google"] == 1) {
    require 'controller(404)';
    exit();
}

function sir($username) {
    global $conn;
    $row = $conn->prepare("SELECT client_id FROM clients WHERE username=:username");
    $row->execute(array("username" => $username));
    $row = $row->fetch(PDO::FETCH_ASSOC);
    return $row['client_id'];
}

function generateRandomUsernamePassword($usernameLength = 8, $passwordLength = 12) {
    $usernameChars = 'abcdefghijklmnopqrstuvwxyz0123456789';
    $passwordChars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()_+-={}[]|:;"<>,.?/';

    $username = '';
    $password = '';

    for ($i = 0; $i < $usernameLength; $i++) {
        $username .= $usernameChars[rand(0, strlen($usernameChars) - 1)];
    }

    for ($i = 0; $i < $passwordLength; $i++) {
        $password .= $passwordChars[rand(0, strlen($passwordChars) - 1)];
    }

    return array('username' => $username, 'password' => $password);
}

function generateApiKeys() {
    $length = 32;
    $bytes = openssl_random_pseudo_bytes($length, $strong);
    return bin2hex($bytes);
}

function convertEmailToUsername($email) {
    $username = strstr($email, '@', true);
    $username = str_replace('.', '', $username);
    return $username;
}

$client = new Google_Client();
$client->setClientId($settings["gkey"]);
$client->setClientSecret($settings["gsecret"]);
$client->setRedirectUri(site_url("g-login"));

$client->addScope("email");
$client->addScope("profile");

if (isset($_REQUEST['code'])) {
    $token = $client->fetchAccessTokenWithAuthCode($_REQUEST['code']);

    if (!isset($token["error"])) {
        $client->setAccessToken($token['access_token']);
        $google_oauth = new Google_Service_Oauth2($client);
        $google_account_info = $google_oauth->userinfo->get();

        $name  = $google_account_info->name;
        $email = $google_account_info->email;

        $row = $conn->prepare("SELECT * FROM clients WHERE email=:email");
        $row->execute(array("email" => $email));
        $row = $row->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            // ---------- Existing User Login ----------
            unset($_SESSION["recaptcha"]);
            $_SESSION["msmbilisim_userlogin"] = 1;
            $_SESSION["msmbilisim_userid"]   = $row["client_id"];
            $_SESSION["msmbilisim_userpass"] = $row["password"];

            $currency_hash = get_currency_hash_by_code($row["currency_type"]);
            $_SESSION["currency_hash"] = $currency_hash;
            $_SESSION["recaptcha"] = false;

            $access = json_decode($row["access"], true);
            if (!empty($access["admin_access"])) {
                $_SESSION["msmbilisim_adminlogin"] = 1;
            }

            // Remember Me Cookies
            setcookie("u_id", $row["client_id"], strtotime('+7 days'), '/', null, null, true);
            setcookie("u_password", $row["password"], strtotime('+7 days'), '/', null, null, true);
            setcookie("u_login", 'ok', strtotime('+7 days'), '/', null, null, true);
            setcookie("currency_hash", $currency_hash, strtotime('+7 days'), '/', null, null, true);

            // Report & Update
            $insert = $conn->prepare("INSERT INTO client_report SET client_id=:c_id, action=:action, report_ip=:ip, report_date=:date");
            $insert->execute(array("c_id" => $row["client_id"], "action" => "Member logged in with Google.", "ip" => GetIP(), "date" => date("Y-m-d H:i:s")));

            $update = $conn->prepare("UPDATE clients SET login_date=:date, login_ip=:ip WHERE client_id=:c_id");
            $update->execute(array("c_id" => $row["client_id"], "date" => date("Y-m-d H:i:s"), "ip" => GetIP()));

            header('Location:' . site_url(''));
            exit();

        } else {
            // ---------- New User Register ----------
            $credentials   = generateRandomUsernamePassword();
            $username      = convertEmailToUsername($email);
            $pass          = $credentials['password'];
            $apikey        = generateApiKeys();
            $ref_code      = substr(md5(microtime()), rand(0, 26), 8);
            $selectedLang  = "en";   
            $phone         = "";     

            $conn->beginTransaction();
            $insert = $conn->prepare("INSERT INTO clients SET 
               name=:name,
               username=:username,
               email=:email,
               password=:pass,
               lang=:lang,
               telephone=:phone,
               register_date=:date,
               apikey=:key,
               ref_code=:ref_code,
               email_type=:type,
               balance=:spent,
               spent=:spent,
               currency_type=:currency_type
            ");

            $insert = $insert->execute(array(
                "name"          => $name,
                "username"      => $username,
                "email"         => $email,
                "pass"          => md5($pass),
                "lang"          => $selectedLang,
                "phone"         => $phone,
                "date"          => date("Y-m-d H:i:s"),
                "key"           => $apikey,
                "ref_code"      => $ref_code,
                "type"          => 2, 
                "spent"         => "0",
                "currency_type" => get_default_currency()
            ));

            if ($insert) {
                $conn->commit();
                $client_id = sir($username);

                $_SESSION["msmbilisim_userid"]   = $client_id;
                $_SESSION["msmbilisim_userpass"] = md5($pass);

                $currency_hash = get_currency_hash_by_code(get_default_currency());
                $_SESSION["currency_hash"] = $currency_hash;
                $_SESSION["recaptcha"] = false;

                setcookie("u_id", $client_id, strtotime('+7 days'), '/', null, null, true);
                setcookie("u_password", md5($pass), strtotime('+7 days'), '/', null, null, true);
                setcookie("u_login", 'ok', strtotime('+7 days'), '/', null, null, true);
                setcookie("currency_hash", $currency_hash, strtotime('+7 days'), '/', null, null, true);

                $insert = $conn->prepare("INSERT INTO client_report SET client_id=:c_id, action=:action, report_ip=:ip, report_date=:date");
                $insert->execute(array("c_id" => $client_id, "action" => "Registered & logged in with Google.", "ip" => GetIP(), "date" => date("Y-m-d H:i:s")));

                header('Location:' . site_url(''));
                exit();

            } else {
                $conn->rollBack();
                header('Location:' . site_url(''));
                exit();
            }
        }

    } else {
        header('Location:' . site_url(''));
        exit();
    }
} else {
    header('location:' . $client->createAuthUrl());
    exit();
}
?>
